// ==UserScript==
// @name         5ch オリジナルポップアップ （本文内 ID 用）
// @namespace    http://tampermonkey.net/
// @version      1.2
// @description  本文中の ID:xxxx をポップアップリンク化し、ポップアップ表示スクリプトの関数を呼び出す
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// @run-at       document-end
// ==/UserScript==

(function () {
    'use strict';

    // スタイルを追加
    const style = document.createElement('style');
    style.textContent = `
        .popup-id {
            color: #aabbcc;
        }
    `;
    document.head.appendChild(style);

    const idRegex = /ID:([A-Za-z0-9]{4,})/g;

    function getTextNodes(element) {
        const walker = document.createTreeWalker(element, NodeFilter.SHOW_TEXT, null, false);
        const nodes = [];
        while (walker.nextNode()) {
            if (walker.currentNode.parentNode.closest('a')) continue;
            nodes.push(walker.currentNode);
        }
        return nodes;
    }

    function wrapIdSpans(element) {
        const nodes = getTextNodes(element);

        nodes.forEach(node => {
            const text = node.nodeValue;
            const frag = document.createDocumentFragment();
            let lastIndex = 0;
            let match;
            let replaced = false;

            idRegex.lastIndex = 0;

            while ((match = idRegex.exec(text)) !== null) {
                const before = text.substring(lastIndex, match.index);
                if (before) frag.appendChild(document.createTextNode(before));

                const span = document.createElement('span');
                span.className = 'popup-id';
                span.setAttribute('data-id', match[1]);
                span.textContent = `ID:${match[1]}`;
                frag.appendChild(span);

                lastIndex = idRegex.lastIndex;
                replaced = true;
            }

            if (lastIndex < text.length) {
                frag.appendChild(document.createTextNode(text.substring(lastIndex)));
            }

            if (replaced) {
                node.parentNode.replaceChild(frag, node);
            }
        });
    }

    function processPostContents() {
        document.querySelectorAll('.post-content').forEach(el => wrapIdSpans(el));
    }

    function fallbackPopup(triggerElem, label) {
        const popup = document.createElement('div');
        popup.style.position = 'absolute';
        popup.style.background = '#333';
        popup.style.color = '#e0e0e0';
        popup.style.border = '1px solid #666';
        popup.style.padding = '10px';
        popup.style.zIndex = 9999;
        popup.style.maxWidth = '300px';
        popup.style.maxHeight = '400px';
        popup.style.overflow = 'auto';
        popup.style.boxShadow = '0 0 10px rgba(0,0,0,0.5)';
        popup.tabIndex = -1;

        popup.textContent = `ポップアップ: ${label}`;
        document.body.appendChild(popup);

        const rect = triggerElem.getBoundingClientRect();
        popup.style.top = window.scrollY + rect.bottom + 5 + 'px';
        popup.style.left = window.scrollX + rect.left + 'px';

        popup.addEventListener('click', () => popup.remove());
        if (popup.focus) popup.focus();
    }

    // uid ポップアップ処理を関数化
    function showUidPopup($element, uidText) {
        if (!uidText.startsWith('ID:')) return;

        // 既存のポップアップを削除（重複表示防止）
        $('.uid-popup').remove();

        const $matchedPosts = $('div.post').filter(function () {
            return $(this).data('userid') === uidText;
        });

        if ($matchedPosts.length === 0) return;

        const $groupContainer = $('<div></div>');

        $matchedPosts.each(function () {
            const $clone = $(this).clone(true, false);
            $clone.find('.hoverAppend').remove();
            $groupContainer.append($clone);
        });

        createPopup($element, 'uid-popup', $groupContainer, true);
    }

    // span.popup-id クリック時に uid ポップアップ処理を呼ぶ
    $(document).on('click', 'span.popup-id', function () {
        const $this = $(this);
        // data-id は ID部分だけなので「ID:」を付ける
        showUidPopup($this, 'ID:' + $this.data('id'));
    });

    processPostContents();

    const observer = new MutationObserver(mutations => {
        mutations.forEach(mutation => {
            mutation.addedNodes.forEach(node => {
                if (node.nodeType === 1) {
                    if (node.classList.contains('post-content')) {
                        wrapIdSpans(node);
                    } else {
                        node.querySelectorAll('.post-content').forEach(el => wrapIdSpans(el));
                    }
                }
            });
        });
    });

    observer.observe(document.body, { childList: true, subtree: true });

})();
